<?php
// 此为Wordpress免费版发布接口，只可以发布标题，内容，TAG
// 需要定时发布，自定义字段，发布回复的朋友，可以购买付费版本：http://www.kalvin.cn/article/locoyspider-wordpress-interface/

// 加载接口所必需的文件
@header('Content-Type: text/html; charset=UTF-8');
require('./wp-load.php');
require_once(ABSPATH . 'wp-admin/includes/admin.php');
@extract($_REQUEST,EXTR_OVERWRITE);

// 刷新分类列表
if (empty($post_title)) {
	wp_dropdown_categories(array(
		'hide_empty' => 0, 
		'hide_if_empty' => false, 
		'taxonomy' => 'category', 
		'name' => 'parent', 
		'orderby' => 'name', 
		'hierarchical' => true, 
		'show_option_none' => __('None'))
	);
	exit();
}

$post_time =  time() ;

// 初始化发贴信息
$post_info = array(
	'post_status' => 'publish', 
	'post_type' => 'post', 
	'post_author' => 1,
	'ping_status' => get_option( 'default_ping_status' ), 
	'comment_status' => get_option( 'default_comment_status' ),
	'post_pingback' => get_option( 'default_pingback_flag' ),
	'post_parent' => 0,
	'menu_order' => 0, 
	'to_ping' => '', 
	'pinged' => '', 
	'post_password' => '',
	'guid' => '', 
	'post_content_filtered' => '', 
	'post_excerpt' => $post_excerpt, 
	'import_id' => 0,
	'post_content' => $post_content, 
	'post_title' => $post_title, 
	'post_category' => array($post_category_id),
	'post_name' => trim($post_name),
	'post_date_gmt' => get_gmt_from_date(gmdate('Y-m-d H:i:s', $post_time + ( get_option( 'gmt_offset' ) * 3600 ))),
	'post_date' => gmdate('Y-m-d H:i:s', $post_time + ( get_option( 'gmt_offset' ) * 3600 )), 
	'tags_input' => array_unique(array_filter(explode(',', $tags))),
);

// 发布文章
$pid = wp_insert_post($post_info); 
if ($pid) {
	echo "[OK] $pid Ok";
} else {
	exit('error');
}
?>